
// Module names are of the form poly_<inkscape-path-id>().  As a result,
// you can associate a polygon in this OpenSCAD program with the corresponding
// SVG element in the Inkscape document by looking for the XML element with
// the attribute id="inkscape-path-id".

// fudge value is used to ensure that subtracted solids are a tad taller
// in the z dimension than the polygon being subtracted from.  This helps
// keep the resulting .stl file manifold.
fudge = 0.1;

module poly_ttcpath38(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[50.716877,-42.539159],[63.178266,-26.094111],[58.696900,-21.775937],[57.356927,-23.436217],[53.599409,-27.088834],[50.937070,-29.039663],[47.817945,-30.741450],[44.291232,-31.945154],[40.406132,-32.401731],[17.294422,-32.401731],[17.294422,34.550536],[17.479266,37.686052],[18.001650,40.382642],[18.813355,42.672958],[19.866160,44.589650],[21.111845,46.165370],[22.502190,47.432769],[25.523982,49.173212],[28.545773,50.072189],[31.181803,50.390911],[33.753541,50.332436],[33.753541,57.642489],[-19.122470,57.642489],[-19.122470,50.332436],[-16.575735,50.390911],[-13.965331,50.072189],[-10.972917,49.173212],[-7.980503,47.432769],[-6.603674,46.165370],[-5.370099,44.589650],[-4.327529,42.672958],[-3.523716,40.382642],[-3.006411,37.686052],[-2.823364,34.550536],[-2.823364,-32.401731],[-25.775062,-32.401731],[-29.665413,-31.952222],[-33.194447,-30.767154],[-36.313651,-29.091713],[-38.974513,-27.171085],[-42.727159,-23.575016],[-44.064286,-21.940439],[-48.385126,-26.253473],[-36.085292,-42.539159],[50.716877,-42.539159]]);
  }
}

module poly_ttcpath10(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[148.313943,-56.316192],[112.720264,7.299771],[298.303382,7.299771],[241.769218,81.397589],[71.477284,81.238228],[70.701432,82.558932],[68.198339,86.043723],[63.704703,90.976621],[60.629148,93.762366],[56.957219,96.641644],[52.656002,99.524959],[47.692584,102.322813],[42.034052,104.945708],[35.647494,107.304146],[28.499996,109.308630],[20.558645,110.869662],[11.790530,111.897745],[2.162735,112.303380],[-7.512743,111.897745],[-16.414203,110.869662],[-24.562315,109.308630],[-31.977748,107.304146],[-38.681169,104.945708],[-44.693248,102.322813],[-50.034653,99.524959],[-54.726054,96.641644],[-58.788118,93.762366],[-62.241516,90.976621],[-67.404984,86.043723],[-70.381808,82.558932],[-71.337338,81.238228],[-241.768189,81.397589],[-298.303382,7.140410],[-112.738786,7.140410],[-148.151873,-56.316192],[-114.065703,-56.316192],[-135.509891,-112.303380],[135.168258,-112.303380],[113.723555,-56.316192],[148.313943,-56.316192]]);
  }
}

module poly_ttcpath42(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[50.716877,-42.539159],[63.178266,-26.094111],[58.696900,-21.775937],[57.356927,-23.436217],[53.599409,-27.088834],[50.937070,-29.039663],[47.817945,-30.741450],[44.291232,-31.945154],[40.406132,-32.401731],[17.294422,-32.401731],[17.294422,34.550536],[17.479266,37.686052],[18.001650,40.382642],[18.813355,42.672958],[19.866160,44.589650],[21.111845,46.165370],[22.502190,47.432769],[25.523982,49.173212],[28.545773,50.072189],[31.181803,50.390911],[33.753541,50.332436],[33.753541,57.642489],[-19.122470,57.642489],[-19.122470,50.332436],[-16.575735,50.390911],[-13.965331,50.072189],[-10.972917,49.173212],[-7.980503,47.432769],[-6.603674,46.165370],[-5.370099,44.589650],[-4.327529,42.672958],[-3.523716,40.382642],[-3.006411,37.686052],[-2.823364,34.550536],[-2.823364,-32.401731],[-25.775062,-32.401731],[-29.665413,-31.952222],[-33.194447,-30.767154],[-36.313651,-29.091713],[-38.974513,-27.171085],[-42.727159,-23.575016],[-44.064286,-21.940439],[-48.385126,-26.253473],[-36.085292,-42.539159],[50.716877,-42.539159]]);
  }
}

module poly_ttcpath22(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-106.267302,18.105489],[-77.326214,69.270716],[-235.457231,69.270716],[-274.527957,18.105489],[-106.267302,18.105489]]);
  }
}

module poly_ttcpath18(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[2.322233,100.675153],[7.027296,100.581389],[11.544039,100.167210],[15.878770,99.424137],[20.037796,98.343693],[24.027427,96.917396],[27.853970,95.136769],[31.523734,92.993333],[35.043027,90.478607],[38.418157,87.584113],[41.655432,84.301372],[44.761162,80.621905],[47.741653,76.537233],[50.603214,72.038876],[53.352154,67.118355],[58.537402,55.976907],[118.889217,-101.178941],[-118.889217,-101.358864],[-58.193196,55.976907],[-55.633912,61.767192],[-52.882001,67.118355],[-49.944085,72.038876],[-46.826785,76.537233],[-43.536721,80.621905],[-40.080516,84.301372],[-36.464789,87.584113],[-32.696162,90.478607],[-28.781256,92.993333],[-24.726692,95.136769],[-20.539091,96.917396],[-16.225073,98.343693],[-11.791261,99.424137],[-7.244275,100.167210],[-2.590736,100.581389],[2.162735,100.675153],[2.322233,100.675153]]);
  }
}

module poly_ttcpath46(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[23.607438,-68.124343],[36.084263,-51.679295],[31.582316,-47.361121],[30.245318,-49.020598],[26.493186,-52.671447],[23.832787,-54.621333],[20.714214,-56.322297],[17.186004,-57.525418],[13.296693,-57.981774],[-9.817074,-57.981774],[-9.817074,8.965353],[-9.632208,12.100926],[-9.109758,14.797679],[-8.297952,17.088248],[-7.245015,19.005269],[-5.999175,20.581378],[-4.608655,21.849212],[-1.586486,23.590598],[1.435683,24.490519],[4.072043,24.810065],[6.644102,24.752393],[6.644102,32.057305],[-46.234996,32.057305],[-46.234996,24.752393],[-43.688180,24.810065],[-41.077694,24.490519],[-38.085185,23.590598],[-35.092677,21.849212],[-33.715805,20.581378],[-32.482191,19.005269],[-31.439588,17.088248],[-30.635749,14.797679],[-30.118427,12.100926],[-29.935375,8.965353],[-29.935375,-57.981774],[-52.867007,-57.981774],[-56.763982,-57.532265],[-60.297993,-56.347197],[-63.420764,-54.671756],[-66.084016,-52.751128],[-69.838857,-49.155059],[-71.176297,-47.520482],[-75.497651,-51.838656],[-63.197303,-68.124343],[23.607438,-68.124343]]);
  }
}

module poly_ttcpath26(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[106.247750,18.105489],[77.486740,69.270716],[235.440767,69.270716],[274.507377,18.105489],[106.247750,18.105489]]);
  }
}

module poly_ttcpath50(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[23.607438,-68.124343],[36.084263,-51.679295],[31.582316,-47.361121],[30.245318,-49.020598],[26.493186,-52.671447],[23.832787,-54.621333],[20.714214,-56.322297],[17.186004,-57.525418],[13.296693,-57.981774],[-9.817074,-57.981774],[-9.817074,8.965353],[-9.632208,12.100926],[-9.109758,14.797679],[-8.297952,17.088248],[-7.245015,19.005269],[-5.999175,20.581378],[-4.608655,21.849212],[-1.586486,23.590598],[1.435683,24.490519],[4.072043,24.810065],[6.644102,24.752393],[6.644102,32.057305],[-46.234996,32.057305],[-46.234996,24.752393],[-43.688180,24.810065],[-41.077694,24.490519],[-38.085185,23.590598],[-35.092677,21.849212],[-33.715805,20.581378],[-32.482191,19.005269],[-31.439588,17.088248],[-30.635749,14.797679],[-30.118427,12.100926],[-29.935375,8.965353],[-29.935375,-57.981774],[-52.867007,-57.981774],[-56.763982,-57.532265],[-60.297993,-56.347197],[-63.420764,-54.671756],[-66.084016,-52.751128],[-69.838857,-49.155059],[-71.176297,-47.520482],[-75.497651,-51.838656],[-63.197303,-68.124343],[23.607438,-68.124343]]);
  }
}

module poly_ttcpath30(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-2.340755,-15.792181],[4.334024,-15.993631],[11.487695,-15.772662],[20.127948,-14.916980],[29.461581,-13.111395],[34.140540,-11.753893],[38.695392,-10.040720],[43.026988,-7.932477],[47.036178,-5.389766],[50.623810,-2.373189],[53.690735,1.156654],[59.360615,-1.999726],[44.547923,-18.285413],[43.138171,-17.038797],[41.470039,-16.181748],[39.243343,-15.792181],[36.570312,-16.024315],[34.100834,-16.535010],[31.582316,-17.277839],[23.127772,-19.900712],[14.542704,-21.952005],[5.584681,-23.288101],[-3.988725,-23.765382],[-10.307985,-23.586860],[-16.398188,-23.062042],[-22.233310,-22.207050],[-27.787327,-21.038008],[-33.034216,-19.571037],[-37.947953,-17.822259],[-42.502515,-15.807798],[-46.671878,-13.543774],[-50.430017,-11.046312],[-53.750911,-8.331533],[-56.608534,-5.415559],[-58.976864,-2.314513],[-60.829877,0.955483],[-62.141549,4.378306],[-62.885857,7.937835],[-63.036777,11.617946],[-62.522443,15.785919],[-61.463110,19.637523],[-59.917188,23.183502],[-57.943089,26.434601],[-55.599222,29.401568],[-52.943997,32.095147],[-50.035826,34.526084],[-46.933119,36.705126],[-40.377739,40.350503],[-33.745140,43.117245],[-27.502606,45.091318],[-22.117423,46.358687],[-16.357465,47.439024],[-8.667968,48.587736],[0.606559,49.263063],[5.730551,49.253908],[11.121610,48.923246],[16.736673,48.203358],[22.532677,47.026524],[28.466558,45.325025],[34.495253,43.031139],[40.575697,40.077147],[46.664829,36.395329],[52.719584,31.917965],[58.696900,26.577336],[54.035455,22.099800],[46.881504,27.946551],[39.680378,32.491984],[32.502273,35.863608],[25.417382,38.188936],[18.495900,39.595476],[11.808020,40.210741],[5.423938,40.162239],[-0.586154,39.577483],[-6.152059,38.583982],[-11.203586,37.309246],[-19.482722,34.426116],[-24.862010,31.948176],[-26.779896,30.895510],[-29.710113,29.021129],[-32.371154,26.899271],[-34.725563,24.565360],[-36.735888,22.054819],[-38.364672,19.403070],[-39.574462,16.645534],[-40.327802,13.817636],[-40.587239,10.954797],[-40.387789,8.359859],[-39.802786,5.818792],[-38.852249,3.346432],[-37.556199,0.957613],[-35.934654,-1.332830],[-34.007636,-3.510063],[-29.317258,-7.465558],[-23.645222,-10.790195],[-17.151687,-13.365296],[-9.996812,-15.072184],[-2.340755,-15.792181]]);
  }
}

module poly_ttcpath14(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[148.313943,-56.316192],[112.720264,7.299771],[298.303382,7.299771],[241.769218,81.397589],[71.477284,81.238228],[70.701432,82.558932],[68.198339,86.043723],[63.704703,90.976621],[60.629148,93.762366],[56.957219,96.641644],[52.656002,99.524959],[47.692584,102.322813],[42.034052,104.945708],[35.647494,107.304146],[28.499996,109.308630],[20.558645,110.869662],[11.790530,111.897745],[2.162735,112.303380],[-7.512743,111.897745],[-16.414203,110.869662],[-24.562315,109.308630],[-31.977748,107.304146],[-38.681169,104.945708],[-44.693248,102.322813],[-50.034653,99.524959],[-54.726054,96.641644],[-58.788118,93.762366],[-62.241516,90.976621],[-67.404984,86.043723],[-70.381808,82.558932],[-71.337338,81.238228],[-241.768189,81.397589],[-298.303382,7.140410],[-112.738786,7.140410],[-148.151873,-56.316192],[-114.065703,-56.316192],[-135.509891,-112.303380],[135.168258,-112.303380],[113.723555,-56.316192],[148.313943,-56.316192]]);
  }
}

module poly_ttcpath34(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-2.340755,-15.792181],[4.334024,-15.993631],[11.487695,-15.772662],[20.127948,-14.916980],[29.461581,-13.111395],[34.140540,-11.753893],[38.695392,-10.040720],[43.026988,-7.932477],[47.036178,-5.389766],[50.623810,-2.373189],[53.690735,1.156654],[59.360615,-1.999726],[44.547923,-18.285413],[43.138171,-17.038797],[41.470039,-16.181748],[39.243343,-15.792181],[36.570312,-16.024315],[34.100834,-16.535010],[31.582316,-17.277839],[23.127772,-19.900712],[14.542704,-21.952005],[5.584681,-23.288101],[-3.988725,-23.765382],[-10.307985,-23.586860],[-16.398188,-23.062042],[-22.233310,-22.207050],[-27.787327,-21.038008],[-33.034216,-19.571037],[-37.947953,-17.822259],[-42.502515,-15.807798],[-46.671878,-13.543774],[-50.430017,-11.046312],[-53.750911,-8.331533],[-56.608534,-5.415559],[-58.976864,-2.314513],[-60.829877,0.955483],[-62.141549,4.378306],[-62.885857,7.937835],[-63.036777,11.617946],[-62.522443,15.785919],[-61.463110,19.637523],[-59.917188,23.183502],[-57.943089,26.434601],[-55.599222,29.401568],[-52.943997,32.095147],[-50.035826,34.526084],[-46.933119,36.705126],[-40.377739,40.350503],[-33.745140,43.117245],[-27.502606,45.091318],[-22.117423,46.358687],[-16.357465,47.439024],[-8.667968,48.587736],[0.606559,49.263063],[5.730551,49.253908],[11.121610,48.923246],[16.736673,48.203358],[22.532677,47.026524],[28.466558,45.325025],[34.495253,43.031139],[40.575697,40.077147],[46.664829,36.395329],[52.719584,31.917965],[58.696900,26.577336],[54.035455,22.099800],[46.881504,27.946551],[39.680378,32.491984],[32.502273,35.863608],[25.417382,38.188936],[18.495900,39.595476],[11.808020,40.210741],[5.423938,40.162239],[-0.586154,39.577483],[-6.152059,38.583982],[-11.203586,37.309246],[-19.482722,34.426116],[-24.862010,31.948176],[-26.779896,30.895510],[-29.710113,29.021129],[-32.371154,26.899271],[-34.725563,24.565360],[-36.735888,22.054819],[-38.364672,19.403070],[-39.574462,16.645534],[-40.327802,13.817636],[-40.587239,10.954797],[-40.387789,8.359859],[-39.802786,5.818792],[-38.852249,3.346432],[-37.556199,0.957613],[-35.934654,-1.332830],[-34.007636,-3.510063],[-29.317258,-7.465558],[-23.645222,-10.790195],[-17.151687,-13.365296],[-9.996812,-15.072184],[-2.340755,-15.792181]]);
  }
}


module drawttc() {

difference(){
//Outline
poly_ttcpath10(20);
union(){
//left
poly_ttcpath22(21);
//center
poly_ttcpath18(21);
//right
poly_ttcpath26(21);}
}
union(){
//T
poly_ttcpath38(20);
//T
poly_ttcpath50(20);
//C
poly_ttcpath30(20);
}
}

module poly_5841path3390(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-6.057143,1.013658],[-5.646993,0.971158],[-5.236833,0.928658],[-5.167233,1.178418],[-5.028803,1.371048],[-4.842763,1.491898],[-4.630363,1.532198],[-4.392333,1.480198],[-4.193843,1.324178],[-4.059813,1.060508],[-4.015113,0.691368],[-4.059813,0.345668],[-4.193833,0.099568],[-4.396713,-0.049842],[-4.653793,-0.099642],[-4.989973,-0.021242],[-5.289533,0.213858],[-5.623523,0.165458],[-5.957503,0.117158],[-5.746563,-1.000522],[-5.535623,-2.118192],[-4.447253,-2.118192],[-3.358873,-2.118192],[-3.358873,-1.732942],[-3.358873,-1.347682],[-4.135243,-1.347682],[-4.911603,-1.347682],[-4.976103,-0.982942],[-5.040503,-0.618192],[-4.762183,-0.721462],[-4.478003,-0.755862],[-3.971903,-0.656262],[-3.549293,-0.357442],[-3.263643,0.100328],[-3.168443,0.676738],[-3.245343,1.178448],[-3.476053,1.623028],[-3.976303,2.049298],[-4.639143,2.191388],[-5.178943,2.111588],[-5.608873,1.872088],[-5.908433,1.497818],[-6.057113,1.013688]]);
  }
}

module poly_5841path3392(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    difference()
    {
       linear_extrude(height=h)
         polygon([[-2.022963,-0.199232],[-2.488783,-0.568372],[-2.632333,-1.086922],[-2.298353,-1.880872],[-1.343273,-2.194342],[-0.394053,-1.880872],[-0.054213,-1.086922],[-0.209483,-0.553722],[-0.646013,-0.199232],[-0.104013,0.219718],[0.083487,0.855458],[-0.297373,1.822258],[-1.305193,2.194328],[-2.280773,1.886708],[-2.740733,0.890618],[-2.567883,0.251948]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-1.853043,-1.028332],[-1.715343,-0.644542],[-1.343273,-0.506842],[-0.968273,-0.644542],[-0.827653,-1.031262],[-0.968273,-1.400402],[-1.334483,-1.541022],[-1.712413,-1.400402]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-1.929243,0.811518],[-1.756393,1.341788],[-1.319863,1.532218],[-0.897993,1.350578],[-0.731003,0.820308],[-0.900923,0.336908],[-1.331583,0.152338],[-1.782753,0.360338]]);
    }
  }
}

module poly_5841path3396(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[6.057117,2.118158],[5.233877,2.118158],[5.233877,-0.984382],[4.170397,-0.360362],[4.170397,-1.107432],[4.870597,-1.505872],[5.389147,-2.194342],[6.057117,-2.194342],[6.057117,2.118158]]);
  }
}

module poly_rect38582(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-8.125223,-3.792852],[8.125223,-3.792852],[8.125223,3.792852],[-8.125223,3.792852]]);
  }
}

module poly_5841path3394(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    difference()
    {
       linear_extrude(height=h)
         polygon([[2.225087,2.118158],[2.225087,1.253898],[0.467277,1.253898],[0.467277,0.533198],[2.330557,-2.194342],[3.021957,-2.194342],[3.021957,0.530268],[3.555167,0.530268],[3.555167,1.253898],[3.021957,1.253898],[3.021957,2.118158],[2.225087,2.118158]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[2.225087,0.530268],[2.225087,-0.937512],[1.237777,0.530268]]);
    }
  }
}

module draw5841()
{
difference(){
poly_rect38582(.5);
union(){
poly_5841path3390(.5);
poly_5841path3392(.5);
poly_5841path3396(.5);
poly_5841path3394(.5);
}
}
}

module poly_toppath38681(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-23.585380,-0.000007],[-23.872575,1.076028],[-24.659619,1.863997],[-25.735317,2.152454],[-26.811014,1.863997],[-27.598058,1.076028],[-27.885253,-0.000007],[-27.598058,-1.076042],[-26.811014,-1.864011],[-25.735317,-2.152468],[-24.659619,-1.864011],[-23.872575,-1.076042],[-23.585380,-0.000007],[-23.585380,-0.000007]]);
  }
}

module poly_rect3860(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-35.816165,-3.355216],[-21.957665,-3.355216],[-21.957665,3.355216],[-35.816165,3.355216]]);
  }
}

module poly_toppath38688(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[29.957043,-0.000007],[30.244238,1.076028],[31.031282,1.863997],[32.106980,2.152454],[33.182677,1.863997],[33.969721,1.076028],[34.256916,-0.000007],[33.969721,-1.076042],[33.182677,-1.864011],[32.106980,-2.152468],[31.031282,-1.864011],[30.244238,-1.076042],[29.957043,-0.000007],[29.957043,-0.000007]]);
  }
}

module poly_toppath3868(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-29.957031,-0.000007],[-30.244226,1.076028],[-31.031270,1.863997],[-32.106968,2.152454],[-33.182665,1.863997],[-33.969709,1.076028],[-34.256904,-0.000007],[-33.969709,-1.076042],[-33.182665,-1.864011],[-32.106968,-2.152468],[-31.031270,-1.864011],[-30.244226,-1.076042],[-29.957031,-0.000007],[-29.957031,-0.000007]]);
  }
}

module poly_rect38603(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[35.816165,-3.355216],[21.957665,-3.355216],[21.957665,3.355216],[35.816165,3.355216]]);
  }
}

module poly_toppath386813(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[23.585393,-0.000007],[23.872588,1.076028],[24.659632,1.863997],[25.735330,2.152454],[26.811027,1.863997],[27.598071,1.076028],[27.885266,-0.000007],[27.598071,-1.076042],[26.811027,-1.864011],[25.735330,-2.152468],[24.659632,-1.864011],[23.872588,-1.076042],[23.585393,-0.000007],[23.585393,-0.000007]]);
  }
}


module poly_lightspath3866(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-44.665694,0.000000],[-45.107247,1.647898],[-46.313592,2.854243],[-47.961490,3.295796],[-49.609388,2.854243],[-50.815733,1.647898],[-51.257284,0.000000],[-50.815731,-1.647898],[-49.609386,-2.854243],[-47.961488,-3.295796],[-46.313590,-2.854243],[-45.107245,-1.647898],[-44.665692,0.000000],[-44.665690,0.000000]]);
  }
}

module poly_lightspath38668(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[44.665694,0.000000],[45.107247,1.647898],[46.313592,2.854243],[47.961490,3.295796],[49.609388,2.854243],[50.815733,1.647898],[51.257284,0.000000],[50.815731,-1.647898],[49.609386,-2.854243],[47.961488,-3.295796],[46.313590,-2.854243],[45.107245,-1.647898],[44.665692,0.000000],[44.665690,0.000000]]);
  }
}

module poly_doorrect3086(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-8.571103,-30.054658],[8.571058,-30.054658],[8.571058,1.741288],[-8.571103,1.741288]]);
  }
}

module poly_doorrect3862(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-11.816193,-31.874548],[11.816193,-31.874548],[11.816193,31.874548],[-11.816193,31.874548]]);
  }
}

module poly_path_down3082(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[3.861679,1.609498],[2.710309,-1.611702],[3.415629,-1.611702],[4.230819,0.772338],[5.019639,-1.611702],[5.709579,-1.611702],[4.556019,1.609498],[3.861679,1.609498]]);
  }
}

module poly_path_down3078(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-3.211321,1.609498],[-3.211321,-1.611702],[-2.578511,-1.611702],[-1.260151,0.539428],[-1.260151,-1.611702],[-0.655901,-1.611702],[-0.655901,1.609498],[-1.308491,1.609498],[-2.607071,-0.491092],[-2.607071,1.609498]]);
  }
}

module poly_path_down3084(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[6.025989,1.609498],[6.025989,-1.611702],[6.676379,-1.611702],[6.676379,1.609498]]);
  }
}

module poly_path_down3086(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[7.293809,1.609498],[7.293809,-1.611702],[9.682239,-1.611702],[9.682239,-1.066772],[7.944199,-1.066772],[7.944199,-0.352662],[9.561389,-0.352662],[9.561389,0.190058],[7.944199,0.190058],[7.944199,1.066768],[9.743759,1.066768],[9.743759,1.609498]]);
  }
}

module poly_path_down3074(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    difference()
    {
       linear_extrude(height=h)
         polygon([[-11.092911,0.018668],[-10.945691,-0.807502],[-10.646871,-1.249152],[-10.229381,-1.539192],[-9.535051,-1.666632],[-8.396871,-1.224982],[-7.968401,0.003288],[-8.392471,1.224968],[-9.526261,1.664428],[-10.668841,1.227168],[-11.092911,0.018668]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-10.422741,-0.003332],[-10.170061,0.827238],[-9.528461,1.108488],[-8.891251,0.829438],[-8.640761,-0.012122],[-8.884661,-0.838292],[-9.528461,-1.110752],[-10.176651,-0.833892]]);
    }
  }
}

module poly_path_down3076(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-7.006001,1.609498],[-7.775041,-1.611702],[-7.109271,-1.611702],[-6.623671,0.600948],[-6.034801,-1.611702],[-5.261371,-1.611702],[-4.696671,0.638298],[-4.202281,-1.611702],[-3.547501,-1.611702],[-4.329731,1.609498],[-5.019671,1.609498],[-5.661271,-0.798712],[-6.300671,1.609498]]);
  }
}

module poly_path_down3080(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-0.130751,0.561398],[0.502059,0.499898],[0.732769,0.967908],[1.205189,1.117328],[1.677599,0.985488],[1.837999,0.673478],[1.769899,0.480118],[1.536989,0.339498],[1.016239,0.198868],[0.282349,-0.119732],[-0.014281,-0.767932],[0.124149,-1.227152],[0.526249,-1.554552],[1.161259,-1.666612],[2.073129,-1.400742],[2.396119,-0.691022],[1.745729,-0.662422],[1.565559,-1.018372],[1.154669,-1.128242],[0.710819,-1.011782],[0.607549,-0.811832],[0.704249,-0.616272],[1.301909,-0.400942],[2.002829,-0.168032],[2.358789,0.159358],[2.488429,0.671318],[2.334619,1.189878],[1.899559,1.550228],[1.198629,1.666678],[0.260399,1.385428],[-0.130711,0.561458]]);
  }
}

module poly_rect3858(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-14.952591,-3.792852],[14.952591,-3.792852],[14.952591,3.792852],[-14.952591,3.792852]]);
  }
}

module poly_path_down3088(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[10.756699,1.609498],[9.987659,-1.611702],[10.653429,-1.611702],[11.139019,0.600948],[11.727889,-1.611702],[12.501329,-1.611702],[13.066029,0.638298],[13.560409,-1.611702],[14.215199,-1.611702],[13.432969,1.609498],[12.743029,1.609498],[12.101429,-0.798712],[11.462019,1.609498]]);
  }
}

module poly_path_down3072(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    difference()
    {
       linear_extrude(height=h)
         polygon([[-14.215221,-1.611702],[-13.620861,-1.611702],[-13.026501,-1.611702],[-12.672201,-1.596302],[-12.413471,-1.550202],[-11.927871,-1.253572],[-11.541151,-0.386752],[-11.514751,0.029628],[-11.760331,1.033228],[-12.415651,1.541348],[-12.667241,1.592448],[-12.991341,1.609448],[-13.603281,1.609448],[-14.215211,1.609448],[-14.213211,-1.459242]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-13.565191,-1.066822],[-13.565191,1.066718],[-13.079601,1.066718],[-12.686291,1.035918],[-12.424811,0.901888],[-12.253431,0.592068],[-12.187531,0.001008],[-12.253431,-0.572482],[-12.438001,-0.884492],[-12.739021,-1.036102],[-13.272961,-1.066902],[-13.565191,-1.066902]]);
    }
  }
}


module poly_path3070(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[3.692859,0.568358],[4.113269,0.701658],[4.533679,0.834958],[4.275859,1.447998],[3.889139,1.880858],[3.380109,2.135738],[2.749499,2.220738],[1.970199,2.074988],[1.343249,1.637738],[0.930159,0.944868],[0.792459,0.038128],[0.930889,-0.914022],[1.346179,-1.625942],[1.987049,-2.071982],[2.802229,-2.220662],[3.516339,-2.104202],[4.082499,-1.754842],[4.338849,-1.419392],[4.521959,-0.963832],[4.092759,-0.861292],[3.663559,-0.758752],[3.545629,-1.057572],[3.344219,-1.286092],[3.077619,-1.431112],[2.758289,-1.479412],[2.325419,-1.393712],[1.981919,-1.136632],[1.759989,-0.687652],[1.685989,-0.026282],[1.759289,0.670988],[1.978999,1.133878],[2.315909,1.393158],[2.740719,1.479558],[3.062249,1.424658],[3.335439,1.259848],[3.549309,0.977128],[3.692869,0.568438]]);
  }
}

module poly_rect3858(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-14.952591,-3.792852],[14.952591,-3.792852],[14.952591,3.792852],[-14.952591,3.792852]]);
  }
}

module poly_path3072(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[5.283679,2.147458],[5.283679,-0.000002],[5.283679,-2.147462],[5.717269,-2.147462],[6.150859,-2.147462],[6.150859,-1.302242],[6.150859,-0.457032],[7.000469,-0.457032],[7.850079,-0.457032],[7.850079,-1.302242],[7.850079,-2.147462],[8.283669,-2.147462],[8.717269,-2.147462],[8.717269,-0.000002],[8.717269,2.147458],[8.283669,2.147458],[7.850079,2.147458],[7.850079,1.208488],[7.850079,0.269528],[7.000469,0.269528],[6.150859,0.269528],[6.150859,1.208488],[6.150859,2.147458],[5.717269,2.147458]]);
  }
}

module poly_path3066(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-5.081561,2.147458],[-5.081561,-0.000002],[-5.081561,-2.147462],[-4.647971,-2.147462],[-4.214371,-2.147462],[-4.214371,-0.000002],[-4.214371,2.147458],[-4.647971,2.147458]]);
  }
}

module poly_path3068(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-3.382341,2.147458],[-3.382341,-0.000002],[-3.382341,-2.147462],[-2.960471,-2.147462],[-2.538591,-2.147462],[-1.659691,-0.713382],[-0.780781,0.720698],[-0.780781,-0.713382],[-0.780781,-2.147462],[-0.377941,-2.147462],[0.024889,-2.147462],[0.024889,-0.000002],[0.024889,2.147458],[-0.410171,2.147458],[-0.845231,2.147458],[-1.710951,0.747068],[-2.576681,-0.653322],[-2.576681,0.747068],[-2.576681,2.147458],[-2.979511,2.147458],[-3.382341,2.147458]]);
  }
}

module poly_path3064(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-8.717301,2.147458],[-8.717301,-0.000002],[-8.717301,-2.147462],[-7.245131,-2.147462],[-5.772961,-2.147462],[-5.772961,-1.784182],[-5.772961,-1.420902],[-6.811531,-1.420902],[-7.850111,-1.420902],[-7.850111,-0.912602],[-7.850111,-0.404302],[-6.953621,-0.404302],[-6.057141,-0.404302],[-6.057141,-0.041022],[-6.057141,0.322268],[-6.953621,0.322268],[-7.850111,0.322268],[-7.850111,1.234858],[-7.850111,2.147458],[-8.283701,2.147458]]);
  }
}


module poly_frontwindows(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-47.776669,-22.765693],[-21.956097,-22.765693],[-21.956097,5.972459],[-47.776669,5.972459]]);
  }
}

module poly_rect386456641(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-294.655053,-27.101545],[-275.366601,-27.101545],[-275.366601,1.484124],[-294.655053,1.484124]]);
  }
}

module poly_rect3864566(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-114.047651,-27.101555],[-94.759199,-27.101555],[-94.759199,1.484114],[-114.047651,1.484114]]);
  }
}

module poly_rect386456644(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-251.585374,-27.101545],[-270.873826,-27.101545],[-270.873826,1.484124],[-251.585374,1.484124]]);
  }
}

module poly_rect43921(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-296.901450,-30.765625],[-296.901450,30.765625],[-273.120204,30.765625],[-249.338954,30.765625],[-249.338954,-30.765625],[-273.120204,-30.765625],[-296.901450,-30.765625]]);
  }
}

module poly_rect3864561(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[37.745679,-26.956165],[3.267400,-26.956165],[3.267400,1.629504],[37.745679,1.629504]]);
  }
}

module poly_rect44229(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-274.249264,-30.613085],[-271.991125,-30.613085],[-271.991125,30.613111],[-274.249264,30.613111]]);
  }
}

module poly_rect38645638(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[219.355029,-26.956285],[184.876750,-26.956285],[184.876750,1.629384],[219.355029,1.629384]]);
  }
}

module poly_rect386456888(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[143.863509,-26.956285],[178.341788,-26.956285],[178.341788,1.629384],[143.863509,1.629384]]);
  }
}

module poly_rect386456352(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[361.363689,-26.956285],[326.885410,-26.956285],[326.885410,1.629384],[361.363689,1.629384]]);
  }
}

module poly_rect38645666(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[114.047619,-27.101555],[94.759167,-27.101555],[94.759167,1.484114],[114.047619,1.484114]]);
  }
}

module poly_rect386456646(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[70.977949,-27.101555],[90.266401,-27.101555],[90.266401,1.484114],[70.977949,1.484114]]);
  }
}

module poly_rect43926(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[116.294029,-30.765625],[116.294029,30.765625],[92.512779,30.765625],[68.731529,30.765625],[68.731529,-30.765625],[92.512779,-30.765625],[116.294029,-30.765625]]);
  }
}

module poly_rect3864566412(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[294.655018,-27.101545],[275.366566,-27.101545],[275.366566,1.484124],[294.655018,1.484124]]);
  }
}

module poly_rect44224(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[93.641829,-30.613085],[91.383690,-30.613085],[91.383690,30.613111],[93.641829,30.613111]]);
  }
}

module poly_rect439218(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[296.901415,-30.765625],[296.901415,30.765625],[273.120169,30.765625],[249.338919,30.765625],[249.338919,-30.765625],[273.120169,-30.765625],[296.901415,-30.765625]]);
  }
}

module poly_rect3864566448(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[251.585339,-27.101545],[270.873791,-27.101545],[270.873791,1.484124],[251.585339,1.484124]]);
  }
}

module poly_rect442295(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[274.249229,-30.613085],[271.991090,-30.613085],[271.991090,30.613111],[274.249229,30.613111]]);
  }
}

module poly_rect4422(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-93.641891,-30.613085],[-91.383752,-30.613085],[-91.383752,30.613111],[-93.641891,30.613111]]);
  }
}

module poly_rect386456(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-37.745741,-26.956165],[-3.267462,-26.956165],[-3.267462,1.629504],[-37.745741,1.629504]]);
  }
}

module poly_rect3864563(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-219.354991,-26.956285],[-184.876712,-26.956285],[-184.876712,1.629384],[-219.354991,1.629384]]);
  }
}

module poly_rect38645688(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-143.863571,-26.956285],[-178.341850,-26.956285],[-178.341850,1.629384],[-143.863571,1.629384]]);
  }
}

module poly_rect38645635(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-361.363689,-26.956285],[-326.885410,-26.956285],[-326.885410,1.629384],[-361.363689,1.629384]]);
  }
}

module poly_rect38645664(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-70.978011,-27.101555],[-90.266463,-27.101555],[-90.266463,1.484114],[-70.978011,1.484114]]);
  }
}

module poly_rect4392(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-116.294071,-30.765625],[-116.294071,30.765625],[-92.512821,30.765625],[-68.731571,30.765625],[-68.731571,-30.765625],[-92.512821,-30.765625],[-116.294071,-30.765625]]);
  }
}

module poly_path2996(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-27.453150,-45.406250],[-31.290010,-44.791260],[-35.561364,-43.169922],[-39.975615,-40.877686],[-44.241162,-38.250000],[-51.159755,-33.330078],[-53.984350,-31.093750],[-53.984350,9.437500],[-54.640650,9.750000],[-53.984350,10.062500],[-53.984350,13.437500],[-54.640650,13.750000],[-53.984350,14.062500],[-53.984350,17.437500],[-54.640650,17.750000],[-53.984350,18.062500],[-53.984350,21.437500],[-54.640650,21.750000],[-53.984350,22.062500],[-53.984350,25.437500],[-54.640650,25.750000],[-53.984350,26.062500],[-53.984350,29.437500],[-54.640650,29.750000],[-53.984350,30.062500],[-53.984350,33.437500],[-54.640650,33.750000],[-53.984350,34.062500],[-53.984350,37.437500],[-54.640650,37.750000],[-53.984350,38.062500],[-53.984350,41.437500],[-54.640650,41.750000],[-53.984350,42.062500],[-53.984350,45.406250],[-0.328150,45.406250],[0.328150,45.406250],[53.984350,45.406250],[53.984350,42.062500],[54.640650,41.750000],[53.984350,41.437500],[53.984350,38.062500],[54.640650,37.750000],[53.984350,37.437500],[53.984350,34.062500],[54.640650,33.750000],[53.984350,33.437500],[53.984350,30.062500],[54.640650,29.750000],[53.984350,29.437500],[53.984350,26.062500],[54.640650,25.750000],[53.984350,25.437500],[53.984350,22.062500],[54.640650,21.750000],[53.984350,21.437500],[53.984350,18.062500],[54.640650,17.750000],[53.984350,17.437500],[53.984350,14.062500],[54.640650,13.750000],[53.984350,13.437500],[53.984350,10.062500],[54.640650,9.750000],[53.984350,9.437500],[53.984350,-31.093750],[51.159755,-33.330078],[44.241162,-38.250000],[39.975615,-40.877686],[35.561364,-43.169922],[31.290010,-44.791260],[27.453150,-45.406250],[3.234350,-45.406250],[0.328150,-45.406250],[-0.328150,-45.406250],[-3.234350,-45.406250],[-27.453150,-45.406250]]);
  }
}


difference(){

difference(){

//main body
translate([-110,0,0]){
rotate([0,90,0]){
poly_path2996(220);
}
}


//side windows and doors
translate([0,0,-15.5])
{
union(){
poly_rect386456641(1.5);
poly_rect3864566(1.5);
poly_rect386456644(1.5);
poly_rect43921(1);
poly_rect3864561(1);
poly_rect44229(1.5);
poly_rect38645638(1);
poly_rect386456888(1);
poly_rect386456352(1);
poly_rect38645666(1.5);
poly_rect386456646(1.5);
poly_rect43926(1);
poly_rect3864566412(1.5);
poly_rect44224(1.5);
poly_rect439218(1);
poly_rect3864566448(1.5);
poly_rect442295(1.5);
poly_rect4422(1.5);
poly_rect386456(1);
poly_rect3864563(1);
poly_rect38645688(1);
poly_rect38645635(1);
poly_rect38645664(1.5);
poly_rect4392(1);
}
}

//side windows and doors
translate([0,0,15.5])
{
rotate([0,180,0]) {
union(){
poly_rect386456641(1.5);
poly_rect3864566(1.5);
poly_rect386456644(1.5);
poly_rect43921(1);
poly_rect3864561(1);
poly_rect44229(1.5);
poly_rect38645638(1);
poly_rect386456888(1);
poly_rect386456352(1);
poly_rect38645666(1.5);
poly_rect386456646(1.5);
poly_rect43926(1);
poly_rect3864566412(1.5);
poly_rect44224(1.5);
poly_rect439218(1);
poly_rect3864566448(1.5);
poly_rect442295(1.5);
poly_rect4422(1.5);
poly_rect386456(1);
poly_rect3864563(1);
poly_rect38645688(1);
poly_rect38645635(1);
poly_rect38645664(1.5);
poly_rect4392(1);
}
}
}


}


//frontdoor
translate([-110.1,0,0]){
rotate([0,90,0]){
poly_doorrect3862(5);
poly_doorrect3086(6);
}}

//backdoor
translate([110.1,0,0]){
rotate([0,270,0]){
poly_doorrect3862(5);
poly_doorrect3086(6);
}}

//front lights
translate([-110,-11,0]){
rotate([0,90,0]){
poly_lightspath3866(4);
poly_lightspath38668(4);
}}

//front top light box
translate([-110,10.5,0]){
rotate([0,90,0]){
poly_rect38603(3);
poly_rect3860(3);
}}

//back lights
translate([110,-11,0]){
rotate([0,270,0]){
poly_lightspath3866(4);
poly_lightspath38668(4);
}}

//back top light box
translate([110,10.5,0]){
rotate([0,270,0]){
poly_rect38603(3);
poly_rect3860(3);
}}

//hole for wheels
translate([91,-3,0]){
rotate([90,0,0])
{cylinder(h = 10, r=2.1);}
}

translate([-91,-3,0]){
rotate([90,0,0]){
cylinder(h = 10, r=2.1);}
}
//end of hole for wheels

//start of edges
union() {
union(){

translate([-112,0,0])
{
rotate([0,20,00])
{
translate([-40,-30,0])
{
cube([40,60,40]);
}


}

rotate([0,-20,00])
{
translate([-40,-30,-40])
{
cube([40,60,40]);
}
}
}

rotate([0,180,0])
{
translate([-112,0,0])
{
rotate([0,20,00])
{
translate([-40,-30,0])
{
cube([40,60,40]);
}
}

rotate([0,-20,00])
{
translate([-40,-30,-40])
{
cube([40,60,40]);
}
}
}

}

}

//windows
translate([0,1.5,0])
{
translate([-113,0,0])
{
rotate([0,110,0])
{
poly_frontwindows(2);
}
}


translate([-111,0,0])
{
rotate([0,250,0])
{
poly_frontwindows(2);
}
}

translate([111,0,0])
{
rotate([0,70,0])
{
poly_frontwindows(2);
}
}


translate([113,0,0])
{
rotate([0,290,0])
{
poly_frontwindows(2);
}
}
}
//end of windows
}

//end of edges

}

//finch
translate([-110,11,0]){
rotate([0,-90,0]){
difference(){
poly_rect3858(.5);
union(){
poly_path3070(.5);
poly_path3072(.5);
poly_path3066(.5);
poly_path3068(.5);
poly_path3064(.5);}}}}

//downsview
translate([110,11,0]){
rotate([0,90,0]){
difference(){
poly_rect3858(.49);
union(){
poly_path_down3082(.5);
poly_path_down3078(.5);
poly_path_down3084(.5);
poly_path_down3086(.5);
poly_path_down3074(.5);
poly_path_down3076(.5);
poly_path_down3080(.5);
poly_path_down3088(.5);
poly_path_down3072(.5);
}}




}}


//front top lights
translate([-108,10.5,0]){
rotate([0,90,0]){
poly_toppath38681(3);
poly_toppath38688(3);
poly_toppath3868(3);
poly_toppath386813(3);
}}

//front bottom lights
//back top light box
translate([108,10.5,0]){
rotate([0,270,0]){
poly_toppath38681(3);
poly_toppath38688(3);
poly_toppath3868(3);
poly_toppath386813(3);
}}

//start 5841 and TTC
translate([0,3.5,-15])
{

translate([88,0,0]){
rotate([0,180,0]) {
draw5841();
}}

translate([-88,0,0]){
rotate([0,180,0]) {
draw5841();
}}

translate([-36,0,0]){
rotate([0,180,0]) {
scale(.03,.03,.03){
drawttc();
}
}}


translate([36,0,0]){
rotate([0,180,0]) {
scale(.03,.03,.03){
drawttc();
}
}}


}

translate([0,3.5,15])
{

translate([88,0,0]){
draw5841();
}

translate([-88,0,0]){
draw5841();
}

translate([36,0,0]){
scale(.03,.03,.03){
drawttc();
}}

translate([-36,0,0]){
scale(.03,.03,.03){
drawttc();
}}




}


//end 5841 and ttc

